<?php
session_start();
require 'db.php';

if (!isset($_SESSION['usuario_id'])) {
  header('Location: index.php');
  exit;
}

$stmt = $pdo->prepare("SELECT nome, saldo FROM usuarios WHERE id = ?");
$stmt->execute([$_SESSION['usuario_id']]);
$usuario = $stmt->fetch();

$dadosJson = file_exists('imagens_menu.json') ? json_decode(file_get_contents('imagens_menu.json'), true) : [];
$logo = isset($dadosJson['logo']) ? $dadosJson['logo'] : 'logo.png';

?>

<!doctype html>
<html lang=pt-BR>
<head>
<meta charset=UTF-8>
<title>Raspadinhas</title>
<meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no">
<link href="https://fonts.googleapis.com/css2?family=Poppins:wght@400;600;700&display=swap" rel=stylesheet>
<link rel=stylesheet href=/css/Gp5kUo2H.css>
</head>
<body>
<div class=header>
<div class=logo>
<img src="images/<?= $logo ?>?v=<?= time() ?>" alt=Logo style=height:40px>
</div>
<div class=saldo-depositar>
<span class=saldo>R$ <?= number_format($usuario['saldo'], 2, ',', '.') ?></span>
<button class=btn-depositar onclick='window.location.href="deposito.php"'> Recarregar</button>
</div>
</div>

<div class="banners">
    
    <img src="images/bannermenu.webp" class="banner">
  </a>
</div>

<div class=container>
<h2 style="margin-left:5px">
  <i class="fa-solid fa-box active"></i> Pacotes
</h2>




  <!-- novo container para as raspadinhas -->
  <div class="raspadinha-lista">
<?php
  $imagensMenu = file_exists('imagens_menu.json') ? json_decode(file_get_contents('imagens_menu.json'), true) : [];
$raspadinhas = [
  [
    "id" => 1,
    "imagem" => isset($imagensMenu['menu1']) ? "images/" . $imagensMenu['menu1'] . "?v=" . filemtime("images/" . $imagensMenu['menu1']) : "images/menu1.png",
    "valor" => "R$1,00",
    "premio" => "R$ 2.000,00"
  ],
  [
    "id" => 2,
    "imagem" => isset($imagensMenu['menu2']) ? "images/" . $imagensMenu['menu2'] . "?v=" . filemtime("images/" . $imagensMenu['menu2']) : "images/menu2.png",
    "valor" => "R$5,00",
    "premio" => "R$ 1.200,00"
  ],
  [
    "id" => 3,
    "imagem" => isset($imagensMenu['menu3']) ? "images/" . $imagensMenu['menu3'] . "?v=" . filemtime("images/" . $imagensMenu['menu3']) : "images/menu3.png",
    "valor" => "R$15,00",
    "premio" => "R$ 5.000,00"
  ],
  [
    "id" => 4,
    "imagem" => isset($imagensMenu['menu4']) ? "images/" . $imagensMenu['menu4'] . "?v=" . filemtime("images/" . $imagensMenu['menu4']) : "images/menu4.png",
    "valor" => "R$50,00",
    "premio" => "R$ 80.000,00"
  ],
    [
    "id" => 5,
    "imagem" => isset($imagensMenu['menu5']) ? "images/" . $imagensMenu['menu5'] . "?v=" . filemtime("images/" . $imagensMenu['menu3']) : "images/menu5.png",
    "valor" => "R$1,00",
    "premio" => "R$ 3.000,00"
  ],
];
foreach ($raspadinhas as $r) {
  echo '
    <div class="raspadinha-card">
      <a href="roleta.php?id=' . $r['id'] . '" style="text-decoration: none; color: inherit;">
        <div style="position: relative;">
          <img src="' . $r['imagem'] . '" alt="Banner">
          <span class="valor-label">' . $r['valor'] . '</span>
        </div>
        <div class="raspadinha-info">
          <div class="raspadinha-titulo">PRÊMIOS ATÉ ' . $r['premio'] . '</div>
          <div class="raspadinha-nome">' . ($r['nome'] ?? '') . '</div>
        </div>
      </a>
    </div>
  ';
}

    ?>
  </div>
</div>

<div class=rodape-info>
<div class=logo>
<img src="images/<?= $logo ?>?v=<?= time() ?>" alt=Logo style=height:40px>
</div>
<p>Nome! é a maior e melhor plataforma de premiações do Brasil</p>
<p>© 2025 Show de prêmios!. Todos os direitos reservados.</p>
</div>

<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">

<div class="footer">
  <a href="index" >
    <div><i class="fas fa-house"></i><br></div>
  </a>
  <a href="menu" class="active">
    <div><i class="fas fa-box"></i><br></div>
  </a>
  <a href="deposito" class="deposito-btn">
    <div><i class="fas fa-credit-card"></i><br></div>
  </a>
  <a href="afiliado">
    <div><i class="fas fa-user-plus"></i><br></div>
  </a>
  <a href="perfil">
    <div><i class="fas fa-user-group"></i><br></div>
  </a>
</div>

</body>
</html>