<?php
session_start();
require 'db.php';

if (!isset($_SESSION['usuario_id'])) {
  header('Location: index.php');
  exit;
}

$stmt = $pdo->prepare("SELECT nome, saldo, codigo_convite FROM usuarios WHERE id = ?");
$stmt->execute([$_SESSION['usuario_id']]);
$usuario = $stmt->fetch();

$dadosJson = file_exists('imagens_menu.json') ? json_decode(file_get_contents('imagens_menu.json'), true) : [];
$logo = isset($dadosJson['logo']) ? $dadosJson['logo'] : 'logo.png';

?>

<!doctype html>
<html lang=pt-BR>
<head>
<meta charset=UTF-8>
<meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no">
<link href="https://fonts.googleapis.com/css2?family=Poppins:wght@400;600;700&display=swap" rel=stylesheet>
<title>Perfil</title>
<link rel=stylesheet href=/css/qW8zDnE4.css>
</head>
<body>
<div class=header>
<div class=logo>
<img src="images/<?= $logo ?>?v=<?= time() ?>" alt=Logo style=height:40px>
</div>
<div style=display:flex;align-items:center>
<div class=saldo-topo>R$ <?= number_format($usuario['saldo'], 2, ',', '.') ?></div>
<button class=btn-depositar-topo onclick='window.location.href="deposito.php"'>Depositar</button>
</div>
</div>
<div class=perfil-box>
<div class=perfil-header>
<img src="https://i.pravatar.cc/100?u=<?= $usuario['nome'] ?>" alt=Avatar>
<div class=perfil-info>
Conta: <strong><?= htmlspecialchars($usuario['nome']) ?></strong><br>
ID: <?= $_SESSION['usuario_id'] ?>
</div>
</div>
<div class=saldo-section>
<div class=saldo-title>Saldo: <strong>R$ <?= number_format($usuario['saldo'], 2, ',', '.') ?></strong></div>
<div class=btn-duplo>
<button class=btn-verde onclick='window.location.href="deposito"'>Depositar</button>
<button class=btn-laranja onclick='window.location.href="saque"'>Sacar</button>
</div>
</div>
<div class=painel>
<a href=afiliado class=painel-item>
<i class="fas fa-user"></i> Painel do Afiliado <span>›</span>
</a>
<a href=https://t.me/ class=painel-item>
<i class="fas fa-headset"></i> Atendimento online <span>›</span>
</a>
<a href=https://t.me/ target=_blank class=painel-item>
<i class="fas fa-bullhorn"></i> Canal Oficial <span>›</span>
</a>
<a href=logout.php class=painel-item>
<i class="fas fa-sign-out-alt"></i> Sair da conta <span>›</span>
</a>
</div>
</div>

<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">

<div class="footer">
  <a href="index" >
    <div><i class="fas fa-house"></i><br></div>
  </a>
  <a href="menu">
    <div><i class="fas fa-box"></i><br></div>
  </a>
  <a href="deposito" class="deposito-btn">
    <div><i class="fas fa-credit-card"></i><br></div>
  </a>
  <a href="afiliado">
    <div><i class="fas fa-user-plus"></i><br></div>
  </a>
  <a href="perfil" class="active">
    <div><i class="fas fa-user-group"></i><br></div>
  </a>
</div>


<script>function copiarLink(){const e=document.getElementById("linkAfiliado").innerText;navigator.clipboard.writeText(e).then((function(){document.getElementById("msgCopiado").style.display="block",setTimeout((()=>{document.getElementById("msgCopiado").style.display="none"}),2e3)}),(function(e){alert("Erro ao copiar o link: "+e)}))}</script>
</body>
</html>
