<?php
session_start();
require 'db.php';

if (!isset($_SESSION['admin']) || $_SESSION['admin'] !== true) {
  header('Location: login.php');
  exit;
}

$id = intval($_POST['id'] ?? 0);
$acao = $_POST['acao'] ?? '';

if ($id <= 0 || !in_array($acao, ['aprovar', 'recusar'])) {
  exit("Requisição inválida.");
}

// Buscar saque
$stmt = $pdo->prepare("SELECT * FROM saques WHERE id = ?");
$stmt->execute([$id]);
$saque = $stmt->fetch(PDO::FETCH_ASSOC);

if (!$saque || $saque['status'] !== 'pendente') {
  exit("Saque inválido ou já processado.");
}

// Função de log
function logDetalhado($titulo, $conteudo) {
    $hora = date('[Y-m-d H:i:s]');
    $texto = "$hora $titulo\n";
    if (is_array($conteudo) || is_object($conteudo)) {
        $texto .= json_encode($conteudo, JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE) . "\n\n";
    } else {
        $texto .= $conteudo . "\n\n";
    }
    file_put_contents("log_saque.txt", $texto, FILE_APPEND);
}

// Detectar tipo de chave Pix para BSPay
function detectarKeyType($key) {
    $keyLimpa = preg_replace('/\D/', '', $key);
    if (preg_match('/^\d{11}$/', $keyLimpa)) return 'CPF';
    if (preg_match('/^\d{14}$/', $keyLimpa)) return 'CNPJ';
    if (filter_var($key, FILTER_VALIDATE_EMAIL)) return 'EMAIL';
    if (preg_match('/^\+\d{1,3}\d{10,11}$/', $key)) return 'PHONE';
    return 'EVP';
}

// Obter token da BSPay
function getTokenBSPay($client_id, $client_secret) {
    $url = "https://api.bspay.co/v2/oauth/token";

    $data = http_build_query([
        'grant_type' => 'client_credentials'
    ]);

    $ch = curl_init($url);
    curl_setopt_array($ch, [
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_POST => true,
        CURLOPT_USERPWD => "$client_id:$client_secret",
        CURLOPT_POSTFIELDS => $data,
        CURLOPT_HTTPHEADER => ["Content-Type: application/x-www-form-urlencoded"],
        CURLOPT_TIMEOUT => 10,
    ]);

    $response = curl_exec($ch);
    $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    curl_close($ch);

    if ($httpCode === 200) {
        $res = json_decode($response, true);
        return $res['access_token'] ?? null;
    }
    return null;
}

if ($acao === 'aprovar') {
    // Credenciais da BSPay
    $CLIENT_ID = 'aranamikel_3777525743514951';
    $CLIENT_SECRET = 'e7ce3d6e894d795cbadff7e4c4e0d43f406e125a58b7de182c5e3fc40723abfa';

    $token = getTokenBSPay($CLIENT_ID, $CLIENT_SECRET);
    if (!$token) {
        exit("Erro ao obter token BSPay.");
    }

    $external_id = uniqid("saque_user{$saque['usuario_id']}_");

    // Monta payload de pagamento
    $payload = [
        "amount" => (float)$saque['valor'],
        "description" => "Saque do usuário #{$saque['usuario_id']}",
        "external_id" => $external_id,
        "creditParty" => [
            "name" => "Usuário Plataforma", // pode ser genérico se não tiver nome
            "keyType" => detectarKeyType($saque['chave_pix']),
            "key" => $saque['chave_pix'],
            "taxId" => "00000000000" // opcional mas requerido se CPF real for necessário
        ]
    ];

    // Enviar para BSPay
    $ch = curl_init("https://api.bspay.co/v2/pix/payment");
    curl_setopt_array($ch, [
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_POST => true,
        CURLOPT_HTTPHEADER => [
            "Authorization: Bearer $token",
            "Content-Type: application/json"
        ],
        CURLOPT_POSTFIELDS => json_encode($payload),
        CURLOPT_TIMEOUT => 15,
    ]);

    $response = curl_exec($ch);
    $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    curl_close($ch);

    logDetalhado("Resposta API BSPay Saque (HTTP $httpCode)", $response);

    $res = json_decode($response, true);

    if ($httpCode === 200 || $httpCode === 201) {
        $stmtUpdate = $pdo->prepare("UPDATE saques SET external_id = ?, status = 'aprovado', data_aprovado = NOW() WHERE id = ?");
        $stmtUpdate->execute([$external_id, $id]);
        header("Location: saques_admin.php");
        exit;
    } else {
        // Falha: devolve saldo
        $pdo->prepare("UPDATE usuarios SET saldo = saldo + ? WHERE id = ?")->execute([$saque['valor'], $saque['usuario_id']]);
        $stmt = $pdo->prepare("UPDATE saques SET status = 'erro_api', data_aprovado = NOW() WHERE id = ?");
        $stmt->execute([$id]);
        exit("Erro ao enviar saque: " . ($res['message'] ?? 'Erro desconhecido'));
    }
}

if ($acao === 'recusar') {
    $pdo->prepare("UPDATE usuarios SET saldo = saldo + ? WHERE id = ?")->execute([$saque['valor'], $saque['usuario_id']]);
    $stmt = $pdo->prepare("UPDATE saques SET status = 'recusado', data_aprovado = NOW() WHERE id = ?");
    $stmt->execute([$id]);

    header("Location: saques_admin.php");
    exit;
}
