<?php
header('Content-Type: application/json');
session_start();
require 'db.php';

if (!isset($_SESSION['usuario_id'])) {
    echo json_encode(['status' => 'erro', 'mensagem' => 'Sessão expirada. Faça login novamente.']);
    exit;
}

$usuario_id = $_SESSION['usuario_id'];
$valor = floatval($_POST['valor'] ?? 0);
$chave_pix = trim($_POST['chave_pix'] ?? '');

// Buscar limites de saque
$config = $pdo->query("SELECT min_saque, max_saque FROM configuracoes LIMIT 1")->fetch();
$min_saque = floatval($config['min_saque']);
$max_saque = floatval($config['max_saque']);

// Buscar comissão do usuário
$stmt = $pdo->prepare("SELECT comissao FROM usuarios WHERE id = ?");
$stmt->execute([$usuario_id]);
$usuario = $stmt->fetch();
$comissao = floatval($usuario['comissao'] ?? 0);

if ($valor < $min_saque || $valor > $max_saque) {
    echo json_encode(['status' => 'erro', 'mensagem' => '❌ Valor fora dos limites permitidos.']);
    exit;
}

if ($valor > $comissao) {
    echo json_encode(['status' => 'erro', 'mensagem' => '❌ Comissão insuficiente.']);
    exit;
}

if (empty($chave_pix)) {
    echo json_encode(['status' => 'erro', 'mensagem' => '❌ Chave Pix inválida.']);
    exit;
}

// Registra no banco como pendente
$stmt = $pdo->prepare("INSERT INTO saques (usuario_id, valor, chave_pix, status, data, tipo) VALUES (?, ?, ?, 'pendente', NOW(), 'comissao')");
$stmt->execute([$usuario_id, $valor, $chave_pix]);

// Desconta da comissão
$stmt = $pdo->prepare("UPDATE usuarios SET comissao = comissao - ? WHERE id = ?");
$stmt->execute([$valor, $usuario_id]);

echo json_encode([
    'status' => 'sucesso',
    'mensagem' => '✅ Saque de comissão solicitado com sucesso! Aguardando processamento do financeiro.'
]);
exit;
