<?php
session_start();
require 'db.php';

if (!isset($_SESSION['admin']) || $_SESSION['admin'] !== true) {
    http_response_code(403);
    exit('Acesso negado.');
}

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    http_response_code(405);
    exit('Método não permitido.');
}


$dados = [
  'min_deposito'    => $_POST['min_deposito'] ?? 0,
  'max_deposito'    => $_POST['max_deposito'] ?? 0,
  'min_saque'       => $_POST['min_saque'] ?? 0,
  'max_saque'       => $_POST['max_saque'] ?? 0,
  'bonus_inicial'   => $_POST['bonus_inicial'] ?? 0,
  'moeda'           => $_POST['moeda'] ?? '',
  'afiliado_lv1'    => $_POST['afiliado_lv1'] ?? 0,
  'afiliado_lv2'    => $_POST['afiliado_lv2'] ?? 0,
  'tipo_comissao'   => $_POST['tipo_comissao'] ?? '',
  'valor_comissao'  => $_POST['valor_comissao'] ?? 0,
  'valor_comissao_n2' => $_POST['valor_comissao_n2'] ?? 0,
  'bonus_deposito'  => $_POST['bonus_deposito'] ?? 0,
  'rollover_multiplicador' => $_POST['rollover_multiplicador'] ?? 2,
  'min_saque_comissao' => $_POST['min_saque_comissao'] ?? 10,
  'max_saque_comissao' => $_POST['max_saque_comissao'] ?? 1000,
];

$stmt = $pdo->prepare("
  UPDATE configuracoes SET
    min_deposito = :min_deposito,
    max_deposito = :max_deposito,
    min_saque = :min_saque,
    max_saque = :max_saque,
    bonus_inicial = :bonus_inicial,
    bonus_deposito = :bonus_deposito,
    moeda = :moeda,
    afiliado_lv1 = :afiliado_lv1,
    afiliado_lv2 = :afiliado_lv2,
    tipo_comissao = :tipo_comissao,
    valor_comissao = :valor_comissao,
    valor_comissao_n2 = :valor_comissao_n2,
    min_saque_comissao = :min_saque_comissao,
    max_saque_comissao = :max_saque_comissao,
    rollover_multiplicador = :rollover_multiplicador
  WHERE id = 1
");
$stmt->execute($dados);

$stmt = $pdo->query("SELECT id FROM raspadinhas_config");
while ($r = $stmt->fetch()) {
  $id = $r['id'];

  $chance = $_POST["chance_ganho_$id"] ?? 0;

  $premiosArray = [];
  foreach ($_POST as $key => $value) {
    if (preg_match('/^premios_' . $id . '_(.+)$/', $key, $matches)) {
      $premio = $matches[1];
      $premiosArray[$premio] = floatval($value);
    }
  }
  $premiosJson = json_encode($premiosArray);

  $update = $pdo->prepare("UPDATE raspadinhas_config SET chance_ganho = ?, premios_json = ? WHERE id = ?");
  $update->execute([$chance, $premiosJson, $id]);
}

$_SESSION['sucesso'] = true;
header("Location: configuracoes_admin.php");
exit;
