<?php
session_start();
require 'db.php';

header('Content-Type: application/json; charset=utf-8');

if (!isset($_SESSION['usuario_id'])) {
    http_response_code(403);
    echo json_encode(['error' => 'Não autorizado']);
    exit;
}

$external_id = $_GET['external_id'] ?? '';
$usuario_id = $_SESSION['usuario_id'];

if (!$external_id) {
    http_response_code(400);
    echo json_encode(['error' => 'external_id ausente']);
    exit;
}

$stmt = $pdo->prepare("SELECT status FROM transacoes_pix WHERE external_id = ? AND usuario_id = ?");
$stmt->execute([$external_id, $usuario_id]);
$status = $stmt->fetchColumn();

if ($status === false) {
    http_response_code(404);
    echo json_encode(['error' => 'Transação não encontrada']);
    exit;
}


$stmt = $pdo->prepare("SELECT saldo FROM usuarios WHERE id = ?");
$stmt->execute([$usuario_id]);
$saldo = floatval($stmt->fetchColumn());

echo json_encode([
    'status' => $status,
    'saldo' => number_format($saldo, 2, ',', '.')
]);
