<?php
session_start();
require 'db.php';

if (!isset($_SESSION['admin']) || $_SESSION['admin'] !== true) {
  header('Location: login.php');
  exit;
}

// Processa envio do formulário para atualizar gateways
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    // Atualiza credenciais e ativo
    $ativo = $_POST['ativo'] ?? '';
    $gateways = $_POST['gateways'] ?? [];

    foreach ($gateways as $id => $dados) {
        $client_id = trim($dados['client_id'] ?? '');
        $client_secret = trim($dados['client_secret'] ?? '');
        $callback_base = trim($dados['callback_base'] ?? '');
        $callback_url = rtrim($callback_base, '/') . '/webhook-pix.php';
        $is_ativo = ($ativo == $id) ? 1 : 0;

        $stmt = $pdo->prepare("UPDATE gateways SET client_id = ?, client_secret = ?, callback_url = ?, ativo = ? WHERE id = ?");
        $stmt->execute([$client_id, $client_secret, $callback_url, $is_ativo, $id]);

    }

    header('Location: gateways_admin.php?msg=Salvo com sucesso!');
    exit;
}

// Busca gateways
$gateways = $pdo->query("SELECT * FROM gateways ORDER BY id ASC")->fetchAll(PDO::FETCH_ASSOC);
$mensagem = $_GET['msg'] ?? '';
?>

<!DOCTYPE html>
<html lang="pt-br">
<head>
  <meta charset="UTF-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1" />
  <title>Configuração de Gateways</title>
  <link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;600;700&display=swap" rel="stylesheet" />
  <style>
    /* Copia o seu CSS original e ajusta só alguns detalhes */
    :root {
      --bg-dark: #121212;
      --bg-panel: #1e1e1e;
      --primary-green: #00ff99;
      --text-light: #e0e0e0;
      --radius: 12px;
      --transition: 0.3s ease;
      --border-panel: rgba(0, 255, 153, 0.1);
      --box-shadow-hover: 0 0 15px rgba(0, 255, 153, 0.4);
    }
    * {
      box-sizing: border-box;
      margin: 0;
      padding: 0;
    }
    body {
      font-family: 'Inter', sans-serif;
      background: linear-gradient(to bottom right, #0d0d0d, #1a1a1a);
      color: var(--text-light);
      min-height: 100vh;
    }
    .sidebar {
      position: fixed;
      top: 0;
      left: 0;
      width: 260px;
      height: 100%;
      background: #101010;
      padding: 30px 20px;
      color: var(--primary-green);
      border-right: 2px solid var(--primary-green);
    }
    .sidebar h2 {
      font-size: 24px;
      text-align: center;
      margin-bottom: 30px;
      font-weight: 700;
    }
    .sidebar ul {
      list-style: none;
      padding: 0;
    }
    .sidebar ul li {
      margin-bottom: 15px;
    }
    .sidebar ul li a {
      display: block;
      padding: 12px 20px;
      background-color: #1b1b1b;
      color: var(--text-light);
      border: 1px solid transparent;
      border-radius: var(--radius);
      text-decoration: none;
      transition: var(--transition);
    }
    .sidebar ul li a:hover {
      background-color: var(--primary-green);
      color: #000;
      border-color: var(--primary-green);
    }
    .content {
      margin-left: 260px;
      padding: 40px;
      max-width: calc(100% - 260px);
    }
    h2 {
      font-size: 28px;
      color: var(--primary-green);
      margin-bottom: 30px;
    }
    form {
      max-width: 800px;
    }
    table {
      width: 100%;
      border-collapse: separate;
      border-spacing: 0 8px;
      background: transparent;
    }
    thead tr th {
      padding: 14px;
      color: var(--primary-green);
      font-weight: 700;
      text-align: left;
      border-radius: var(--radius);
      user-select: none;
    }
    tbody tr {
      box-shadow: 0 0 3px rgb(0 255 153);
      border-radius: 20px;
      transition: box-shadow 0.3s;
      background: ;
    }
    tbody tr:hover {
      box-shadow: var(--box-shadow-hover);
    }
    tbody tr td {
      padding: 14px;
      color: var(--text-light);
      vertical-align: middle;
      border: none;
    }
    input[type="text"], input[type="password"] {
      width: 100%;
      padding: 8px;
      font-size: 14px;
      border: 1px solid var(--border-panel);
      border-radius: var(--radius);
      background-color: var(--bg-dark);
      color: var(--text-light);
      transition: border-color 0.3s;
    }
    input[type="text"]:focus, input[type="password"]:focus {
      outline: none;
      border-color: var(--primary-green);
      box-shadow: 0 0 6px var(--primary-green);
    }
    input[type="radio"] {
      cursor: pointer;
      width: 18px;
      height: 18px;
      vertical-align: middle;
    }
    label {
      font-size: 14px;
      color: var(--primary-green);
      user-select: none;
      cursor: pointer;
    }
    .btn {
      padding: 12px 20px;
      background-color: var(--primary-green);
      color: #000;
      font-weight: 700;
      border: none;
      border-radius: var(--radius);
      cursor: pointer;
      transition: background-color 0.3s;
      margin-top: 20px;
    }
    .btn:hover {
      background-color: #00cc77;
    }
    .msg-sucesso {
      color: var(--primary-green);
      margin-bottom: 20px;
      font-weight: 600;
    }
    @media (max-width: 768px) {
      .sidebar {
        position: relative;
        width: 100%;
        height: auto;
        border: none;
        padding: 20px;
        text-align: center;
      }
      .sidebar ul {
        display: flex;
        flex-wrap: wrap;
        justify-content: center;
        gap: 15px;
      }
      .sidebar ul li {
        width: auto;
        margin-bottom: 10px;
      }
      .content {
        margin-left: 0;
        padding: 20px;
        max-width: 100%;
      }
      table {
        font-size: 14px;
      }
    }
  </style>
</head>
<body>
  <div class="sidebar">
    <h2>Admin</h2>
    <ul>
      <li><a href="painel_admin.php">Painel de Controle</a></li>
      <li><a href="configuracoes_admin.php">Configurações</a></li>
      <li><a href="usuarios_admin.php">Config Usuários</a></li>
      <li><a href="saques_admin.php">Saques</a></li>
      <li><a href="saques_comissao_admin.php">Saques Afiliado</a></li>
      <li><a href="gateways_admin.php">Gateways</a></li>
      <li><a href="pix_admin.php">Transacoes</a></li>
    </ul>
  </div>

  <div class="content">
    <h2>Configuração de Gateways de Pagamento</h2>

    <?php if ($mensagem): ?>
      <div class="msg-sucesso"><?= htmlspecialchars($mensagem) ?></div>
    <?php endif; ?>

    <form method="POST" action="gateways_admin.php">
      <table>
        <thead>
          <tr>
            <th>Ativo</th>
            <th>Gateway</th>
            <th>Client ID</th>
            <th>Client Secret</th>
            <th>Callback (seu dominio)</th>
          </tr>
        </thead>
        <tbody>
          <?php foreach ($gateways as $g): ?>
          <tr>
            <td style="text-align:center;">
              <input 
                type="radio" 
                name="ativo" 
                value="<?= $g['id'] ?>" 
                <?= $g['ativo'] ? 'checked' : '' ?> 
                title="Ativar este gateway"
              />
            </td>
            <td><?= htmlspecialchars(ucfirst($g['nome'])) ?></td>
            <td>
              <input 
                type="text" 
                name="gateways[<?= $g['id'] ?>][client_id]" 
                value="<?= htmlspecialchars($g['client_id']) ?>" 
                placeholder="Client ID"
                required
              />
            </td>
            <td>
              <input 
                type="password" 
                name="gateways[<?= $g['id'] ?>][client_secret]" 
                value="<?= htmlspecialchars($g['client_secret']) ?>" 
                placeholder="Client Secret"
                required
              />
            </td>
            <td>
<input 
  type="text" 
  name="gateways[<?= $g['id'] ?>][callback_base]" 
  value="<?= htmlspecialchars(str_replace('/webhook-pix.php', '', $g['callback_url'])) ?>" 
  placeholder="https://caixamisteriosahub.online"
  required
/>

</td>

          </tr>
          <?php endforeach; ?>
        </tbody>
      </table>
      <button class="btn" type="submit">Salvar Configurações</button>
    </form>
  </div>

</body>
</html>
