<?php
$duracao = 60 * 60 * 24 * 30;

session_set_cookie_params([
    'lifetime' => $duracao,
    'path' => '/',
    'secure' => false,
    'httponly' => true,
    'samesite' => 'Lax'
]);

ini_set('session.gc_maxlifetime', $duracao);
session_start();
require 'db.php';
$usuarioLogado = false;
$usuario = null;
if (isset($_SESSION['usuario_id'])) {
  $usuarioLogado = true;
  $stmt = $pdo->prepare("SELECT nome, saldo FROM usuarios WHERE id = ?");
  $stmt->execute([$_SESSION['usuario_id']]);
  $usuario = $stmt->fetch();
}
$jsonFile = __DIR__ . '/imagens_menu.json';
$imagens = file_exists($jsonFile) ? json_decode(file_get_contents($jsonFile), true) : [];
$banner1 = isset($imagens['banner1']) ? $imagens['banner1'] : 'banner.webp';
$banner2 = isset($imagens['banner2']) ? $imagens['banner2'] : 'banner2.png';
$dadosJson = file_exists('imagens_menu.json') ? json_decode(file_get_contents('imagens_menu.json'), true) : [];
$logo = isset($dadosJson['logo']) ? $dadosJson['logo'] : 'logo.png';
$stmt = $pdo->prepare("SELECT nome, saldo FROM usuarios WHERE id = ?");
$stmt->execute([$_SESSION['usuario_id']]);
$usuario = $stmt->fetch();
?>
<!doctype html>
<html lang=pt-BR>
<head>
<!-- Meta Pixel Code -->

<!-- End Meta Pixel Code -->     
<meta charset=UTF-8>
<title>Início - Caixas</title>
<meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no">
<link href="https://fonts.googleapis.com/css2?family=Poppins:wght@400;600;700&display=swap" rel=stylesheet>
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css">
<link rel=stylesheet href=./css/bR3cXvZ1.css>
<style>
#auth-msg,.tabs button{font-weight:600;font-size:14px}.modal{display:none;position:fixed;z-index:9999;left:0;top:0;width:100%;height:100%;backdrop-filter:blur(1px);-webkit-backdrop-filter:blur(2px);justify-content:center;align-items:center;animation:.3s ease-in-out fadeIn;font-family: Poppins, sans-serif;}.modal.show,.tabs{display:flex}@keyframes fadeIn{from{opacity:0;transform:scale(.95)}to{opacity:1;transform:scale(1)}}.modal-content{background-color:#121419;color:#fff;border-radius:12px;width:100%;max-width:400px;font-family: Poppins, sans-serif;;padding:30px 20px;box-shadow:0 0 20px rgba(0,0,0,.5);position:relative}.modal .close{position:absolute;top:1px;right:15px;font-size:26px;color:#aaa;cursor:pointer}.modal .close:hover{color:#fff}.tabs{justify-content:space-between;margin-bottom:20px;gap:10px}.tabs button{flex:1;padding:10px;border:2px solid #007fdb;background-color:transparent;color:#007fdb;border-radius:8px;cursor:pointer;transition:.3s}.tabs button.active,.tabs button:hover{background-color:#007fdb;color:#fff}.tab-content input{display:block;width:100%;margin:12px 0;padding:12px 16px;font-size:15px;border:none;border-radius:8px;background-color:#2c2c2c;color:#fff}.tab-content input::placeholder{color:#aaa}.tab-content button{width:100%;padding:12px 0;margin-top:14px;background-color:#007fdb;color:#fff;border:none;font-size:16px;border-radius:8px;cursor:pointer;font-weight:700;transition:background-color .3s}.tab-content button:hover{background-color:#00a90d}#auth-msg{margin-top:10px;color:#e74c3c;text-align:center}
    .input-group{position:relative;margin-bottom:15px}.input-group .icon{position:absolute;left:10px;top:50%;transform:translateY(-50%);color:#aaa;font-size:16px;pointer-events:none}.input-group input{width:100%;padding:10px 10px 10px 35px;border-radius:8px;border:none;background-color:#2c2c2c;color:#fff;font-size:15px}
</style>
</head>
<body>
    <script>
  const urlParams = new URLSearchParams(window.location.search);
  const codigoConvite = urlParams.get('codigo');
  if (codigoConvite) {
    localStorage.setItem('codigo_convite', codigoConvite);
  }
</script>
<div class=header>
<div class=logo>
<img src="images/<?= $logo ?>?v=<?= time() ?>" alt=Logo style=height:40px>
</div>
<div class=saldo-depositar>
<?php if ($usuarioLogado): ?>
  <span class="saldo">R$ <?= number_format($usuario['saldo'], 2, ',', '.') ?></span>
<?php endif; ?>
<button class=btn-depositar onclick='window.location.href="deposito.php"'> Recarregar</button>
</div>

</div>
<div class="banners">
  <a href="/menu">
    <img src="images/<?= $banner1 ?>?v=<?= filemtime("images/$banner1") ?>" class="banner">
  </a>

  <a href="/menu">
    <img src="images/<?= $banner2 ?>?v=<?= filemtime("images/$banner2") ?>" class="banner">
  </a>

  <a href="/menu">
    <img src="images/banner3.webp" class="banner">
  </a>
</div>



<div class=container>
<h2 style="margin-left:5px">
  <i class="fa-solid fa-box active"></i> Pacotes
</h2>




  <!-- novo container para as raspadinhas -->
  <div class="raspadinha-lista">
<?php
  $imagensMenu = file_exists('imagens_menu.json') ? json_decode(file_get_contents('imagens_menu.json'), true) : [];
$raspadinhas = [
  [
    "id" => 1,
    "imagem" => isset($imagensMenu['menu1']) ? "images/" . $imagensMenu['menu1'] . "?v=" . filemtime("images/" . $imagensMenu['menu1']) : "images/menu1.png",
    "valor" => "R$ 1,00",
    "premio" => "R$ 2.000,00"
  ],
  [
    "id" => 2,
    "imagem" => isset($imagensMenu['menu2']) ? "images/" . $imagensMenu['menu2'] . "?v=" . filemtime("images/" . $imagensMenu['menu2']) : "images/menu2.png",
    "valor" => "R$ 5,00",
    "premio" => "R$ 1.200,00"
  ],
  [
    "id" => 3,
    "imagem" => isset($imagensMenu['menu3']) ? "images/" . $imagensMenu['menu3'] . "?v=" . filemtime("images/" . $imagensMenu['menu3']) : "images/menu3.png",
    "valor" => "R$ 15,00",
    "premio" => "R$ 5.000,00"
  ],
  [
    "id" => 4,
    "imagem" => isset($imagensMenu['menu5']) ? "images/" . $imagensMenu['menu5'] . "?v=" . filemtime("images/" . $imagensMenu['menu3']) : "images/menu5.png",
    "valor" => "R$ 30,00",
    "premio" => "R$ 3.000,00"
  ],
  [
    "id" => 5,
    "imagem" => isset($imagensMenu['menu4']) ? "images/" . $imagensMenu['menu4'] . "?v=" . filemtime("images/" . $imagensMenu['menu4']) : "images/menu4.png",
    "valor" => "R$ 50,00",
    "premio" => "R$ 80.000,00"
  ],
];
foreach ($raspadinhas as $r) {
  echo '
    <div class="raspadinha-card">
      <a href="roleta.php?id=' . $r['id'] . '" style="text-decoration: none; color: inherit;">
        <div style="position: relative;">
          <img src="' . $r['imagem'] . '" alt="Banner">
          <span class="valor-label">' . $r['valor'] . '</span>
        </div>
        <div class="raspadinha-info">
          <div class="raspadinha-titulo">PRÊMIOS ATÉ ' . $r['premio'] . '</div>
          <div class="raspadinha-nome">' . ($r['nome'] ?? '') . '</div>
        </div>
      </a>
    </div>
  ';
}

    ?>
  </div>
</div>

<div class="como-funciona-container">
  <h2>Calma, calma. Já vou explicar...</h2>
  <h3>COMO FUNCIONA</h3>
  <p>Abrir um pacote é bem simples! Veja o passo a passo para começar agora</p>

  <div class="passo">
    <h4>Deposite</h4>
    <p>Clique no botão verde no canto superior do site e escolha a quantia ideal para fazer seu depósito.</p>
    <img src="images/h1.webp" alt="Deposite">
  </div>

  <div class="passo">
    <h4>Escolha um Pacote</h4>
    <p>Encontre o pacote ou uma raspadinha perfeita para você e clique em abrir.</p>
    <img src="images/h2.webp" alt="Escolha um pacote">
  </div>

  <div class="passo">
    <h4>Clique em abrir</h4>
    <p>Após escolher sua premiação desejada, clique em abrir.</p>
    <img src="images/h3.webp" alt="Clique em abrir">
  </div>

  <div class="passo">
    <h4>Aproveite!</h4>
    <p>Parabéns! Agora você pode retirar o valor no PIX ou enviar o produto para sua casa.</p>
    <img src="images/h4.webp" alt="Aproveite!">
  </div>
</div>


<div class=rodape-info>
<div class=logo>
<img src="images/<?= $logo ?>?v=<?= time() ?>" alt=Logo style=height:40px>
</div>
<p>Nome! é a maior e melhor plataforma de premiações do Brasil</p>
<p>© 2025 Show de prêmios!. Todos os direitos reservados.</p>
</div>
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">

<div class="footer">
  <a href="index" class="active">
    <div><i class="fas fa-house"></i><br></div>
  </a>
  <a href="menu">
    <div><i class="fas fa-box"></i><br></div>
  </a>
  <a href="deposito" class="deposito-btn">
    <div><i class="fas fa-credit-card"></i><br></div>
  </a>
  <a href="afiliado">
    <div><i class="fas fa-user-plus"></i><br></div>
  </a>
  <a href="perfil">
    <div><i class="fas fa-user-group"></i><br></div>
  </a>
</div>


<?php if (!$usuarioLogado): ?>
<div id="modal-auth" class="modal show">
  <div class="modal-content">
      <span class="close" onclick="fecharModal()">&times;</span>

    <div class="tabs">
      <button onclick="mostrarTab('login')">Login</button>
      <button onclick="mostrarTab('register')">Cadastro</button>
    </div>
<div id="form-login" class="tab-content">
  <form id="loginForm">
    <div class="input-group">
      <span class="icon"><i class="fa fa-phone"></i></span>
      <input type="text" name="telefone" placeholder="(00) 00000-0000" required>
    </div>
    <div class="input-group">
      <span class="icon"><i class="fa fa-lock"></i></span>
      <input type="password" name="senha" placeholder="Senha" required>
    </div>
    <button type="submit">Entrar</button>
  </form>
</div>
<div id="form-register" class="tab-content" style="display:none;">
  <form id="registerForm">
    <div class="input-group">
      <span class="icon"><i class="fa fa-user"></i></span>
      <input type="text" name="nome" placeholder="Nome completo" required>
    </div>
    <div class="input-group">
      <span class="icon"><i class="fa fa-phone"></i></span>
      <input type="text" name="telefone" placeholder="(00) 00000-0000" required>
    </div>
    <div class="input-group">
      <span class="icon"><i class="fa fa-envelope"></i></span>
      <input type="email" name="email" placeholder="Email" required>
    </div>
    <div class="input-group">
      <span class="icon"><i class="fa fa-lock"></i></span>
      <input type="password" name="senha" placeholder="Senha" required>
    </div>
    <div class="input-group">
      <span class="icon"><i class="fa fa-gift"></i></span>
      <input type="text" name="codigo_convite" placeholder="Código de convite (opcional)" value="<?= htmlspecialchars($_GET['code'] ?? '') ?>">
    </div>
    <button type="submit">Cadastrar</button>
  </form>
</div>
    <div id="auth-msg" style="margin-top:10px; color:red;"></div>
  </div>
</div>
<script>
  document.addEventListener('DOMContentLoaded', function () {
    const campoCodigo = document.querySelector('#registerForm input[name="codigo_convite"]');
    const valorSalvo = localStorage.getItem('codigo_convite');
    if (campoCodigo && valorSalvo) {
      campoCodigo.value = valorSalvo;
    }
  });
</script>
<script>
  function mostrarTab(tab) {
    document.getElementById('form-login').style.display = (tab === 'login') ? 'block' : 'none';
    document.getElementById('form-register').style.display = (tab === 'register') ? 'block' : 'none';
    document.getElementById('auth-msg').innerText = '';

    if (tab === 'register') {
      const campoCodigo = document.querySelector('#registerForm input[name="codigo_convite"]');
      const valorSalvo = localStorage.getItem('codigo_convite');
      if (campoCodigo && valorSalvo) {
        campoCodigo.value = valorSalvo;
      }
    }
  }
</script>
<?php endif; ?>
<script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.7.0/jquery.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/jquery.mask/1.14.16/jquery.mask.min.js"></script>
<script>
  $(document).ready(function(){
    $('#loginForm input[name="telefone"], #registerForm input[name="telefone"]').mask('(00) 00000-0000');
  });
</script>
<script>
  const usuarioLogado = <?= $usuarioLogado ? 'true' : 'false' ?>;
  document.querySelectorAll('a[data-requer-login]').forEach(link => {
    link.addEventListener('click', function(e) {
      if (!usuarioLogado) {
        e.preventDefault();
        document.getElementById('modal-auth').classList.add('show');
        return false;
      }
    });
  });
  document.querySelectorAll('.btn-depositar').forEach(btn => {
    btn.addEventListener('click', function(e) {
      if (!usuarioLogado) {
        e.preventDefault();
        document.getElementById('modal-auth').classList.add('show');
        return false;
      }
    });
  });
  const ctaBtn = document.querySelector('.cta-bloco .btn-jogar');
  if (ctaBtn) {
    ctaBtn.addEventListener('click', function(e) {
      if (!usuarioLogado) {
        e.preventDefault();
        document.getElementById('modal-auth').classList.add('show');
        return false;
      }
    });
  }
</script>
<script>
  function fecharModal() {
    const modal = document.getElementById('modal-auth');
    if (modal) {
      modal.classList.remove('show');
    }
  }
</script>
<script>
$(document).ready(function() {
  // Login AJAX
  $('#loginForm').submit(function(e) {
    e.preventDefault();
    const formData = $(this).serialize();
    $.ajax({
      url: 'login_ajax.php',
      type: 'POST',
      data: formData,
      success: function(response) {
        if (response.trim() === 'success') {
          location.reload();
        } else {
          $('#auth-msg').text(response);
        }
      },
      error: function() {
        $('#auth-msg').text('Erro ao processar requisição. Tente novamente.');
      }
    });
  });

  $('#registerForm').submit(function(e) {
    e.preventDefault();
    const formData = $(this).serialize();
    $.ajax({
      url: 'register_ajax.php',
      method: 'POST',
      data: formData,
      success: function(response) {
        console.log('Resposta:', response);
        if (response.trim() === 'success') {
        window.location.href = 'deposito';
      } else {
        $('#auth-msg').text(response);
      }
    },
      error: function() {
        $('#auth-msg').text('Erro ao processar requisição. Tente novamente.');
      }
    });
  });
});
</script>

</body>
</html>