<?php
ini_set('session.gc_maxlifetime', 7200);
session_set_cookie_params(7200);

session_start();
require 'db.php';

$erro = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $telefone = preg_replace('/\D/', '', $_POST['telefone']);
    $senha = $_POST['senha'];

    if (empty($telefone) || empty($senha)) {
        $erro = "Preencha todos os campos.";
    } else {
        $stmt = $pdo->prepare("SELECT * FROM usuarios WHERE REPLACE(REPLACE(REPLACE(REPLACE(telefone, '(', ''), ')', ''), '-', ''), ' ', '') = ?");
        $stmt->execute([$telefone]);
        $usuario = $stmt->fetch();

        if (!$usuario || !password_verify($senha, $usuario['senha'])) {
            $erro = "Telefone ou senha incorretos.";
        } else {
            $_SESSION['usuario_id'] = $usuario['id'];
            $_SESSION['usuario_nome'] = $usuario['nome'];
            header("Location: index.php");
            exit;
        }
    }
}

$jsonFile = __DIR__ . '/imagens_menu.json';
$imagens = file_exists($jsonFile) ? json_decode(file_get_contents($jsonFile), true) : [];

$banner1 = $imagens['banner1'] ?? 'banner.webp';
$banner2 = $imagens['banner2'] ?? 'banner2.png';
$logo = $imagens['logo'] ?? 'logo.png';
?>

<!DOCTYPE html>
<html lang="pt-br">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>Entrar</title>
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css">
  <link href="https://fonts.googleapis.com/css2?family=Quicksand:wght@500;700&display=swap" rel="stylesheet">
  <script src="https://code.jquery.com/jquery-3.7.0.min.js"></script>
  <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery.mask/1.14.16/jquery.mask.min.js"></script>
  <link rel=stylesheet href=/css/34fg73et.css>
  <style>
.erro-login {
  background-color: #ffe5e5;
  color: #c0392b;
  border: 1px solid #e74c3c;
  padding: 12px 20px;
  margin: 0 auto 20px auto;
  border-radius: 8px;
  text-align: center;
  font-weight: bold;
  width: 90%;
  max-width: 400px;
  box-shadow: 0 2px 4px rgba(0,0,0,0.1);
  font-family: 'Quicksand', sans-serif;
}
</style>
</head>
<body>
  <form method="post" class="form-box">
    <div class="logo">
      <div style="text-align: center;">
        <img src="images/<?= $logo ?>?v=<?= time() ?>" alt="Logo" style="height: 40px;">
      </div>
      <h2> Bem vindo de volta! </h2>
      <p>Conecte-se para acompanhar seus prêmios,<br> depósitos e muito mais.</p>
      <div class="input-group">
        <span class="icon"><i class="fas fa-phone"></i></span>
        <input type="text" name="telefone" placeholder="(00) 00000-0000" required>
      </div>
      <div class="input-group">
        <span class="icon"><i class="fas fa-lock"></i></span>
        <input type="password" name="senha" placeholder="Sua senha" required>
      </div>
      <?php if (!empty($erro)): ?>
        <p style="color: red; text-align: center; margin-top: 10px; font-family: 'Quicksand', sans-serif;">
          <?= htmlspecialchars($erro) ?>
        </p>
      <?php endif; ?>
      <button type="submit">Entrar</button>
      <div class="footer-text">
        Ainda não tem conta? <a href="register.php">Cadastre-se</a>
      </div>
    </div>
  </form>
  <script>
    $(document).ready(function() {
      $('input[name="telefone"]').mask('(00) 00000-0000');
    });
  </script>
</body>
</html>
