<?php
ob_start();
session_start();
require 'db.php';

// --- Verificação de Login ---
if (!isset($_SESSION['usuario_id'])) {
    header('Location: index.php');
    exit;
}

// --- Carregamento dos Dados ---
$idJogo = isset($_GET['id']) ? intval($_GET['id']) : 1;

// Buscar dados do jogo
$stmt = $pdo->prepare("SELECT * FROM raspadinhas_config WHERE id = ? AND ativa = 1");
$stmt->execute([$idJogo]);
$jogo = $stmt->fetch();

if (!$jogo) {
    echo "Jogo inválido!";
    exit;
}

// Buscar dados do usuário
$stmt = $pdo->prepare("SELECT * FROM usuarios WHERE id = ?");
$stmt->execute([$_SESSION['usuario_id']]);
$usuario = $stmt->fetch();

// --- Lógica de Negócio ---
$custo = floatval($jogo['valor']);
$saldo = floatval($usuario['saldo']);

$chanceGanho = isset($usuario['percentual_ganho']) && $usuario['percentual_ganho'] !== null
    ? floatval($usuario['percentual_ganho'])
    : floatval($jogo['chance_ganho']);

$moeda = $jogo['moeda'] ?? 'R$';

// Distribuição de prêmios
$premios_json = $jogo['premios_json'] ?? '{"0": 100}';
$distribuicao_json = json_decode($premios_json, true);

$distribuicao = [];
foreach ($distribuicao_json as $valor => $chance) {
    $valorNum = floatval($valor);
    $chanceNum = floatval($chance);
    if ($chanceNum > 0) {
        $distribuicao[$valorNum] = $chanceNum;
    }
}
if (empty($distribuicao)) {
    $distribuicao[0] = 100;
}

function sortearPremioDistribuido($distribuicao) {
    $total = array_sum($distribuicao);
    if ($total <= 0) return 0.00;
    $rand = mt_rand(1, $total);
    $acumulado = 0;
    foreach ($distribuicao as $valor => $chance) {
        $acumulado += $chance;
        if ($rand <= $acumulado) {
            return $valor;
        }
    }
    return 0.00;
}

// --- POST principal ---
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    if ($saldo < $custo) {
        $_SESSION['erro_roleta'] = "Saldo insuficiente!";
        header("Location: roleta.php?id=$idJogo");
        exit;
    }

    $ganhou = false;
    $premio_real = 0.00;

    if (mt_rand(1, 100) <= $chanceGanho) {
        $ganhou = true;
        $premio_real = sortearPremioDistribuido($distribuicao);
    } else {
        $ganhou = false;
        $premio_real = 0.00;
    }

    // --- Prêmio visual = real quando ganha, 0 quando não ganha ---
    $premio_visual = $ganhou ? $premio_real : 0.00;

    // --- Atualizações no Banco ---
    $novo_saldo = $saldo - $custo + $premio_real;
    $stmt = $pdo->prepare("UPDATE usuarios SET saldo = ? WHERE id = ?");
    $stmt->execute([$novo_saldo, $_SESSION['usuario_id']]);

    $stmt = $pdo->prepare("INSERT INTO historico_jogos (usuario_id, raspadinha_id, valor_apostado, valor_premiado) VALUES (?, ?, ?, ?)");
    $stmt->execute([$_SESSION['usuario_id'], $idJogo, $custo, $premio_real]);

    $_SESSION['roleta_resultado'] = [
        'ganhou' => $ganhou,
        'premio_real' => $premio_real,
        'premio_visual' => $premio_visual
    ];

    header("Location: roleta.php?id=$idJogo");
    exit;
}

// --- Resultado da sessão ---
$resultado = null;
if (isset($_SESSION['roleta_resultado'])) {
    $resultado = $_SESSION['roleta_resultado'];
    unset($_SESSION['roleta_resultado']);
}

$logo = 'logo.png';

// --- Montagem dos segmentos visuais (ordem garantida) ---
$segmentos_visuais = array_keys($distribuicao);

// mantém a ordem original do JSON
$segmentos_visuais = array_values($segmentos_visuais);

if (!in_array(0, $segmentos_visuais)) {
    array_unshift($segmentos_visuais, 0);
}

?>
<!doctype html>
<html lang="pt-br">
<head>
    <meta charset="UTF-8">
    <title>Roleta da Sorte</title>
    <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no">
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@400;600;700&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="css/roleta.css?v=<?= time() ?>">
</head>
<body>
<script src="https://cdn.jsdelivr.net/npm/canvas-confetti@1.5.1/dist/confetti.browser.min.js"></script>

<div class="user-header">
    <div class="user-header-logo">
        <img src="images/<?= $logo ?>" alt="Logo">
    </div>
    <div class="user-header-saldo">
        <span class="saldo-label">Seu Saldo</span>
        <span class="saldo-valor"><?= $moeda ?> <?= number_format($usuario['saldo'], 2, ',', '.') ?></span>
    </div>
</div>

<div class="game-container">
    <div class="reel-wrapper">
        <div class="reel-pointer"></div>
        <div class="reel-strip" id="reelStrip">
            <?php foreach ($segmentos_visuais as $valorSegmento): ?>
                <div class="reel-item <?= ($valorSegmento == 0 ? 'item-nao-ganhou-bg' : '') ?>" 
                     data-valor="<?= $valorSegmento ?>">

                    <?php if ($valorSegmento == 0): ?>
                        <span class="item-nao-ganhou">Não Ganhou</span>
                    <?php else: ?>
                        <?php
                        $caminho_base = "images/caixa/{$valorSegmento}";
                        $caminho_webp = $caminho_base . ".webp";
                        $caminho_png  = $caminho_base . ".png";
                        $imagem_final_url = null;

                        if (file_exists($caminho_webp)) {
                            $imagem_final_url = $caminho_webp;
                        } elseif (file_exists($caminho_png)) {
                            $imagem_final_url = $caminho_png;
                        }
                        ?>
                        <?php if ($imagem_final_url): ?>
                            <img src="<?= $imagem_final_url ?>" alt="Prêmio de <?= $valorSegmento ?>">
                        <?php endif; ?>
                        <span class="reel-item-text"><?= $valorSegmento ?> Reais</span>
                        <span class="valor"><?= $moeda ?> <?= number_format($valorSegmento, 2, ',', '.') ?></span>
                    <?php endif; ?>
                </div>
            <?php endforeach; ?>
        </div>
    </div>

    <div id="mensagemResultado" class="mensagem"></div>
</div>


    <?php if ($resultado === null): ?>
        <form method="post" action="roleta.php?id=<?= $idJogo ?>">
            <button class="btn-jogar">Abrir pacote <?= $moeda ?><?= number_format($custo, 2, ',', '.') ?></button>
        </form>
    <?php else: ?>
        <a href="roleta.php?id=<?= $idJogo ?>" class="btn-jogar" style="text-decoration: none; display: none;" id="btnJogarNovamente">Jogar Novamente</a>
    <?php endif; ?>

    <?php if (isset($_SESSION['erro_roleta'])): ?>
        <div class="mensagem erro"><?= $_SESSION['erro_roleta'] ?></div>
        <?php unset($_SESSION['erro_roleta']); ?>
    <?php endif; ?>
</div>

<div class="premios-disponiveis-container">
    <h3>Prêmios Disponíveis</h3>
    <div class="premios-grid">
        <?php
        $premios_para_exibir = array_filter(array_keys($distribuicao), fn($valor) => $valor > 0);
        rsort($premios_para_exibir);
        foreach ($premios_para_exibir as $valorPremio):
            $caminho_base = "images/caixa/{$valorPremio}";
            $caminho_webp = $caminho_base . ".webp";
            $caminho_png = $caminho_base . ".png";
            $imagem_final_url = null;
            if (file_exists($caminho_webp)) {
                $imagem_final_url = $caminho_webp;
            } elseif (file_exists($caminho_png)) {
                $imagem_final_url = $caminho_png;
            }
            ?>
            <div class="premio-item">
                <?php if ($imagem_final_url): ?>
                    <img src="<?= $imagem_final_url ?>" alt="Prêmio de <?= $valorPremio ?>">
                <?php endif; ?>
                <span class="premio-item-text"><?= $moeda ?> <?= number_format($valorPremio, 2, ',', '.') ?></span>
            </div>
        <?php endforeach; ?>
    </div>
</div>

<div id="gameData"
     data-segmentos='<?= json_encode($segmentos_visuais) ?>'
     <?php if ($resultado): ?>
     data-premio-real="<?= $resultado['premio_real'] ?>"
     data-premio-visual="<?= $resultado['premio_visual'] ?>"
     data-moeda="<?= $moeda ?>"
     <?php endif; ?>>
</div>

<script src="js/game.js?v=<?= time() ?>"></script>

<div id="resultadoModal" class="modal-overlay" style="display: none;">
    <div class="modal-content">
        <h2 id="modalTitle"></h2>
        <div class="modal-prize-container">
            <img id="modalImage" src="" alt="Prêmio">
        </div>
        <p id="modalText"></p>
        <button id="modalContinueBtn" class="btn-continuar">Continuar</button>
    </div>
</div>

<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">

<div class="footer">
  <a href="index" class="active">
    <div><i class="fas fa-house"></i><br></div>
  </a>
  <a href="menu">
    <div><i class="fas fa-box"></i><br></div>
  </a>
  <a href="deposito" class="deposito-btn">
    <div><i class="fas fa-credit-card"></i><br></div>
  </a>
  <a href="afiliado">
    <div><i class="fas fa-user-group"></i><br></div>
  </a>
  <a href="perfil">
    <div><i class="fas fa-user-plus"></i><br></div>
  </a>
</div>

</body>
</html>
