<?php
session_start();
require 'db.php';

if (!isset($_SESSION['admin']) || $_SESSION['admin'] !== true) {
  header('Location: login.php');
  exit;
}

$stmt = $pdo->query("
  SELECT saques.*, usuarios.email 
  FROM saques 
  JOIN usuarios ON usuarios.id = saques.usuario_id 
  WHERE saques.tipo = 'comissao'
  ORDER BY saques.data DESC
");

$saques = $stmt->fetchAll(PDO::FETCH_ASSOC);
?>

<!DOCTYPE html>
<html lang="pt-BR">
<head>
  <meta charset="UTF-8" />
  <title>Admin - Saques de Comissão</title>
  <meta name="viewport" content="width=device-width, initial-scale=1" />
  <link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;600&display=swap" rel="stylesheet" />
  <style>
    :root {
      --bg-dark: #121212;
      --bg-panel: #1e1e1e;
      --primary-green: #00ff99;
      --text-light: #e0e0e0;
      --radius: 12px;
      --transition: 0.3s ease;
      --border-panel: rgba(0, 255, 153, 0.1);
      --box-shadow-hover: 0 0 15px rgba(0, 255, 153, 0.4);
      --btn-green-hover: #00cc77;
      --btn-red-hover: #c0392b;
    }

    * {
      box-sizing: border-box;
      margin: 0;
      padding: 0;
    }

    body {
      font-family: 'Inter', sans-serif;
      background: linear-gradient(to bottom right, #0d0d0d, #1a1a1a);
      color: var(--text-light);
      min-height: 100vh;
    }

    .sidebar {
      position: fixed;
      top: 0;
      left: 0;
      width: 260px;
      height: 100%;
      background: #101010;
      padding: 30px 20px;
      color: var(--primary-green);
      border-right: 2px solid var(--primary-green);
    }

    .sidebar h2 {
      font-size: 24px;
      text-align: center;
      margin-bottom: 30px;
      font-weight: 600;
    }

    .sidebar ul {
      list-style: none;
      padding: 0;
    }

    .sidebar ul li {
      margin-bottom: 15px;
    }

    .sidebar ul li a {
      display: block;
      padding: 12px 20px;
      background-color: #1b1b1b;
      color: var(--text-light);
      border-radius: var(--radius);
      text-decoration: none;
      transition: var(--transition);
      border: 1px solid transparent;
    }

    .sidebar ul li a:hover {
      background-color: var(--primary-green);
      color: #000;
      border-color: var(--primary-green);
    }

    .content {
      margin-left: 260px;
      padding: 40px;
      max-width: calc(100% - 260px);
    }

    h2 {
      font-size: 28px;
      color: var(--primary-green);
      margin-bottom: 30px;
    }

    table {
      width: 100%;
      border-collapse: separate;
      border-spacing: 0 8px;
      background: transparent;
    }

    thead tr th {
      padding: 14px;
      color: var(--primary-green);
      font-weight: 600;
      text-align: left;
      border-radius: var(--radius);
      user-select: none;
    }

    tbody tr {
      box-shadow: 0 0 3px rgb(0 255 153);
      border-radius: var(--radius);
      transition: box-shadow 0.3s;
    }

    tbody tr:hover {
      box-shadow: var(--box-shadow-hover);
    }

    tbody tr td {
      padding: 14px;
      color: var(--text-light);
      vertical-align: middle;
      border: none;
    }

    .btn {
      padding: 8px 14px;
      border: none;
      border-radius: var(--radius);
      cursor: pointer;
      font-weight: 600;
      font-size: 14px;
      text-decoration: none;
      transition: background-color 0.3s;
      color: #000;
      display: inline-block;
      user-select: none;
    }

    .btn-aprovar {
      background-color: var(--primary-green);
    }

    .btn-aprovar:hover {
      background-color: var(--btn-green-hover);
    }

    .btn-recusar {
      background-color: #e74c3c;
      margin-left: 6px;
      color: #fff;
    }

    .btn-recusar:hover {
      background-color: var(--btn-red-hover);
    }

    @media (max-width: 768px) {
      .sidebar {
        position: relative;
        width: 100%;
        height: auto;
        border: none;
        padding: 20px;
        text-align: center;
      }

      .sidebar ul {
        display: flex;
        flex-wrap: wrap;
        justify-content: center;
        gap: 15px;
      }

      .sidebar ul li {
        width: auto;
        margin-bottom: 10px;
      }

      .content {
        margin-left: 0;
        padding: 20px;
        max-width: 100%;
      }

      table {
        font-size: 14px;
      }

      .btn {
        padding: 6px 10px;
        font-size: 12px;
      }
    }
  </style>
</head>
<body>

<div class="sidebar">
    <h2>Admin</h2>
    <ul>
      <li><a href="painel_admin.php">Painel de Controle</a></li>
      <li><a href="configuracoes_admin.php">Configurações</a></li>
      <li><a href="usuarios_admin.php">Config Usuários</a></li>
      <li><a href="saques_admin.php">Saques</a></li>
      <li><a href="saques_comissao_admin.php">Saques Afiliado</a></li>
      <li><a href="gateways_admin.php">Gateways</a></li>
      <li><a href="pix_admin.php">Transacoes</a></li>
    </ul>
  </div>

<div class="content">
  <h2>Saques de Comissão</h2>

  <?php if (empty($saques)): ?>
    <p>Nenhum saque de comissão registrado.</p>
  <?php else: ?>
    <table>
      <thead>
        <tr>
          <th>ID</th>
          <th>Usuário</th>
          <th>Valor</th>
          <th>Chave Pix</th>
          <th>Data</th>
          <th>Status</th>
          <th>Ações</th>
        </tr>
      </thead>
      <tbody>
      <?php foreach ($saques as $saque): ?>
        <tr>
          <td><?= $saque['id'] ?></td>
          <td><?= htmlspecialchars($saque['email']) ?></td>
          <td>R$ <?= number_format($saque['valor'], 2, ',', '.') ?></td>
          <td><?= htmlspecialchars($saque['chave_pix']) ?></td>
          <td><?= date('d/m/Y H:i', strtotime($saque['data'])) ?></td>
          <td><?= ucfirst($saque['status']) ?></td>
          <td>
            <?php if ($saque['status'] === 'pendente'): ?>
              <form action="processar_aprovacao_saque.php" method="POST" style="display:inline;">
                <input type="hidden" name="id" value="<?= $saque['id'] ?>">
                <button type="submit" name="acao" value="aprovar" class="btn btn-aprovar">Aprovar</button>
              </form>
              <form action="processar_aprovacao_saque.php" method="POST" style="display:inline;">
                <input type="hidden" name="id" value="<?= $saque['id'] ?>">
                <button type="submit" name="acao" value="recusar" class="btn btn-recusar" onclick="return confirm('Deseja recusar este saque?')">Recusar</button>
              </form>
            <?php else: ?>
              <em><?= ucfirst($saque['status']) ?></em>
            <?php endif; ?>
          </td>
        </tr>
      <?php endforeach; ?>
      </tbody>
    </table>
  <?php endif; ?>
</div>

</body>
</html>
