<?php
require 'db.php';

header('Content-Type: application/json');

// Recebe o payload raw JSON
$payload = file_get_contents('php://input');
$data = json_decode($payload, true);

if (!$data || !isset($data['status'])) {
    http_response_code(400);
    echo json_encode(['error' => 'Payload inválido']);
    exit;
}

// Compat: externalId/external_id, publicId/transactionId
$externalId = $data['external_id'] ?? ($data['externalId'] ?? null);
if (!$externalId) {
    http_response_code(400);
    echo json_encode(['error' => 'externalId ausente']);
    exit;
}

$transactionId = $data['transactionId'] ?? ($data['publicId'] ?? null);
$status = strtoupper(trim((string)$data['status']));
$amount = floatval($data['amount'] ?? 0);
$fee = floatval($data['fee'] ?? 0);

// Mapear status cashout LotusPay → banco
$statusBanco = match($status) {
    'COMPLETED', 'SUCCEEDED', 'APPROVED' => 'aprovado',
    'FAILED', 'REJECTED', 'ERROR' => 'erro_api',
    'CANCELLED', 'CANCELED' => 'recusado',
    default => 'pendente'
};

// Buscar saque pelo external_id
$stmt = $pdo->prepare("SELECT * FROM saques WHERE external_id = ? LIMIT 1");
$stmt->execute([$externalId]);
$saque = $stmt->fetch(PDO::FETCH_ASSOC);

if (!$saque) {
    http_response_code(404);
    echo json_encode(['error' => 'Saque não encontrado']);
    exit;
}

// Atualizar status, transaction_id e data de atualização
$stmt = $pdo->prepare("UPDATE saques SET status = ?, transaction_id = ?, atualizado_em = NOW() WHERE id = ?");
$stmt->execute([$statusBanco, $transactionId, $saque['id']]);

// Opcional: salvar amount/fee em tabela de logs

http_response_code(200);
echo json_encode(['message' => 'Status atualizado']);
exit;
